function showPartialRequisition(userToken, page = 1, status = 0) {
    $.ajax({
        url: "./ajax/json_for_requisition_v1_0.php",
        type: "POST",
        data: {page, status},
        dataType: "json",
        contentType: "application/x-www-form-urlencoded",
        headers: {
            "token_id": userToken,
            "mode": "1"
        },
        success: function (response) {
            if (response.error_code === 200) {
                populateRequestCards(response.requisitions, userToken, status); // Update requisitions
                generatePagination(response.pagination, userToken); // Generate pagination
            } else {
                alert('Error: ' + response.message);
            }
        },
        error: function (xhr) {
            console.log("AJAX Error:", xhr.responseText);
            alert("Server error. Please try again.");
        }
    });
}

// ✅ Populate Request Cards inside #reqId
function populateRequestCards(requisitions, userToken, status) {
    const reqContainer = document.getElementById("reqId");
    reqContainer.innerHTML = ""; // Clear existing data
    requisitions.forEach(req => {
        const formattedDate = formatDate(req.req_date_of_creation);
        reqContainer.innerHTML += `
            <div class="col-md-4">
                <div class="request-card" 
                    ${status == 0 ? `onclick="sendToAddItem('${req.req_no}', '${userToken}')"` : 
                    status == 4 ? `onclick="sendToEdit('${req.req_no}', '${userToken}')"` : 
                    status == 2 ? `onclick="getPoDetails('${req.req_no}', '${userToken}')"` : "" }>
                    
                    <h5 class="card-title" style="margin-bottom: -7px; display: flex; justify-content: space-between;">
                        <p><strong>Req no.: ${req.req_no}</strong></p>
                        <p><strong> ${formattedDate}</strong></p>
                    </h5>
                    <p style="margin-bottom: 3px;"><strong>Ship Name:</strong> ${req.ship_id}</p>
                    <p style="margin-bottom: 3px;"><strong>Department:</strong> ${req.dept_name} (${req.dept_no})</p>
                    <p><strong>Enter by:</strong> ${req.user_name}</p>
                    
                </div>
            </div>`;
    });
}

// ✅ Generate Pagination Links
function generatePagination(pagination, userToken) {
    const { current_page, total_pages, status } = pagination;
    const paginationContainer = document.querySelector(".pagination");
    paginationContainer.innerHTML = ""; // Clear previous pagination

    // Previous Button
    paginationContainer.innerHTML += `
        <li class="page-item ${current_page == 1 ? 'disabled' : ''}">
            <a class="page-link" href="#" onclick="showPartialRequisition('${userToken}', ${current_page - 1}, ${status})"><<</a>
        </li>`;

    // Page Numbers
    for (let page = 1; page <= total_pages; page++) {
        paginationContainer.innerHTML += `
            <li class="page-item ${page == current_page ? 'active' : ''}">
                <a class="page-link" href="#" onclick="showPartialRequisition('${userToken}', ${page}, ${status})">${page}</a>
            </li>`;
    }

    // Next Button
    paginationContainer.innerHTML += `
        <li class="page-item ${current_page == total_pages ? 'disabled' : ''}">
            <a class="page-link" href="#" onclick="showPartialRequisition('${userToken}', ${current_page + 1}, ${status})">>></a>
        </li>`;
}

// foprmated data 

const formatDate = (dateTime) => {
    const date = new Date(dateTime);
    const day = String(date.getDate()).padStart(2, '0');
    const month = String(date.getMonth() + 1).padStart(2, '0'); // Months are 0-based
    const year = date.getFullYear();
    return `${day}-${month}-${year}`;
};

const sendToAddItem = (reqNo, userToken) => {
    $.ajax({
        url: "./ajax/json_for_requisition_v1_0.php",
        type: "POST",
        data: {reqNo},
        dataType: "json",
        contentType: "application/x-www-form-urlencoded",
        headers: {
            "token_id": userToken,
            "mode": "2"
        },
        success: function (response) {
            if (response.error_code === 200) {
                window.location.href = './add_item_to_requisition.php';
            } else {
                alert('Error: ' + response.message);
            }
        },
        error: function (xhr) {
            console.log("AJAX Error:", xhr.responseText);
            alert("Server error. Please try again.");
        }
    });
};

const sendToEdit = (reqNo, userToken) => {

    alert("tets");
    // $.ajax({
    //     url: "./ajax/json_for_requisition_v1_0.php",
    //     type: "POST",
    //     data: {reqNo},
    //     dataType: "json",
    //     contentType: "application/x-www-form-urlencoded",
    //     headers: {
    //         "token_id": userToken,
    //         "mode": "2"
    //     },
    //     success: function (response) {
    //         if (response.error_code === 200) {
    //             window.location.href = './add_item_to_requisition.php';
    //         } else {
    //             alert('Error: ' + response.message);
    //         }
    //     },
    //     error: function (xhr) {
    //         console.log("AJAX Error:", xhr.responseText);
    //         alert("Server error. Please try again.");
    //     }
    // });
};

const getPoDetails = (reqNo, userToken) => {
    $.ajax({
        url: "./ajax/json_for_track_po_v1_0.php",
        type: "POST",
        data: {req_no: reqNo},
        dataType: "json",
        contentType: "application/x-www-form-urlencoded",
        headers: {
            "token_id": userToken,
            "mode": "1"
        },
        success: function (response) {
            if (response.error_code === 200) {
                const statusColors = ["bg-yellow", "bg-blue", "bg-orange", "bg-green", "bg-red", "bg-orange"];
                vendors = response.data;
                document.getElementById("vendorModal").style.display = "flex";
                const vendorList = document.getElementById("vendorList");
                vendorList.innerHTML = "";
                vendors.slice(0, 10).forEach(vendor => {
                    const div = document.createElement("div");
                    div.className = `col-md-4 vendor-card ${statusColors[vendor.po_status]} p-3 m-2 rounded`;
                    div.style.width = "40%";
                    div.style.minHeight = "15%";
                    const name = document.createElement("h5");
                    name.innerText = vendor.ven_name;
                    div.appendChild(name);
        
                    // Track Order button
                    const trackBtn = document.createElement("button");
                    trackBtn.className = "btn btn-outline-success btn-sm me-2";
                    trackBtn.innerText = "Track Order";
                    trackBtn.style.color = "black";
                    trackBtn.onclick = () => tracThisPo(vendor.req_id, vendor.po_id);
        
                    // Update Status button
                    const updateBtn = document.createElement("button");
                    updateBtn.className = "btn btn-outline-success btn-sm";
                    updateBtn.style.color = "black";
                    updateBtn.innerText = "Update Status";
                    updateBtn.onclick = () => updateVendorStatus(vendor.req_id, vendor.po_id, userToken); // define this function as needed

                     // Details button
                     const detailsBtn = document.createElement("button");
                     detailsBtn.className = "btn btn-outline-success btn-sm";
                     detailsBtn.style.color = "black";
                     detailsBtn.innerText = "Order Details";
                     detailsBtn.onclick = () => poItemList(vendor.req_id, vendor.po_id, userToken); // define this function as needed
        
                    const btnGroup = document.createElement("div");
                    btnGroup.className = "mt-2 d-flex justify-content-center gap-2";
                    
                    if(vendor.po_status > 0) {
                        btnGroup.appendChild(trackBtn);
                    }
                    if(vendor.po_status == 4) {
                        btnGroup.appendChild(updateBtn);
                    }
                    btnGroup.appendChild(detailsBtn);
        
                    div.appendChild(btnGroup);
                    vendorList.appendChild(div);
                });

            } else {
                alert('Error: ' + response.message);
            }
        },
        error: function (xhr) {
            console.log("AJAX Error:", xhr.responseText);
            alert("Server error. Please try again.");
        }
    });
}

const closeVendorModal = () => {
    document.getElementById("vendorModal").style.display = "none";
}

const tracThisPo = (reqId, poId, userToken) => {

    $.ajax({
        url: "./ajax/json_for_track_po_v1_0.php",
        type: "POST",
        data: {req_id: reqId, po_id: poId},
        dataType: "json",
        contentType: "application/x-www-form-urlencoded",
        headers: {
            "token_id": userToken,
            "mode": "2"
        },
        success: function (response) {
            if (response.error_code === 200) {
                const orderData = response.data[0];

        const steps = [
            { key: "req_date_of_creation", label: "Order Generated" },
            { key: "order_placed", label: `Order Placed (${orderData.ven_name})` },
            { key: "prepare_for_dispatch", label: "Prepare for Dispatch" },
            { key: "ready_to_ship", label: "Ready to Ship" },
            { key: "intransit", label: "In Transit" },
            { key: "delivered", label: "Delivered" }
        ];

        const tracker = document.getElementById("orderTracker");
        tracker.innerHTML = ""; // Clear previous content

        steps.forEach((step, index) => {
            const isCompleted = orderData[step.key] !== null;

            const stepElement = document.createElement("div");
            stepElement.classList.add("step");
            if (isCompleted) stepElement.classList.add("completed");

            stepElement.innerHTML = `
                <div class="circle">${index + 1}</div>
                <div class="text">${step.label} ${isCompleted ? `(${orderData[step.key]})` : ""}</div>
            `;

            tracker.appendChild(stepElement);
        });

        document.getElementById("trackerModal").style.display = "block";

            } else {
                alert('Error: ' + response.message);
            }
        },
        error: function (xhr) {
            console.log("AJAX Error:", xhr.responseText);
            alert("Server error. Please try again.");
        }
    });

}

const closeTrackerModal = () => {
    document.getElementById("trackerModal").style.display = "none";
}
const updateVendorStatus = (reqId, poId, userToken) => {
    // Remove existing modal if any
    const existingModal = document.getElementById("deliveryPopup");
    if (existingModal) existingModal.remove();

    // Create overlay
    const overlay = document.createElement("div");
    overlay.id = "deliveryPopup";
    overlay.style.cssText = `
        position: fixed;
        top: 0; left: 0;
        width: 100%; height: 100%;
        background: rgba(0,0,0,0.5);
        display: flex;
        justify-content: center;
        align-items: center;
        z-index: 9999;
    `;

    // Create modal box
    const modal = document.createElement("div");
    modal.style.cssText = `
        background: #fff;
        padding: 20px;
        border-radius: 8px;
        width: 50%;
        max-width: 90%;
        box-shadow: 0 4px 8px rgba(0,0,0,0.2);
    `;

    modal.innerHTML = `
        <h3 class="text-center" style="margin-top: 0; color: #1d5589;">Delivery Received</h3>

        <label for="deliveryDate"><strong>Date:</strong></label><br>
        <input type="date" id="deliveryDate" style="width: 100%;margin-top: -3%;"><br>

        <label for="deliveryNote"><strong>Delivery Note:</strong></label><br>
        <input type="text" id="deliveryNote" style="width: 100%;margin-top: -3%;"><br>

        <label for="uploadFile"><strong>Upload File:</strong></label><br>
        <input type="file" id="uploadFile" style="width: 100%;margin-top: -3%;"><br>

        <label>
            Dispute 
            <input type="checkbox" id="disputeCheck" style="width: 48px;">
        </label><br>

        <div id="disputeExtraFields" style="display: none;margin-top: -3%;">
            <label for="disputeComment"><strong>Comment:</strong></label><br>
            <textarea id="disputeComment" rows="3" style="width: 100%;margin-top: -3%;"></textarea>
        </div>

        <div style="text-align: right;">
            <button class="btn btn-outline-success" onclick="submitVendorStatus('${reqId}', '${poId}', '${userToken}')">Submit</button>
            <button class="btn btn-outline-danger" onclick="document.getElementById('deliveryPopup').remove()">Cancel</button>
        </div>
    `;

    // Add checkbox toggle functionality
    setTimeout(() => {
        const disputeCheck = document.getElementById("disputeCheck");
        const disputeFields = document.getElementById("disputeExtraFields");

        disputeCheck.addEventListener("change", function () {
            disputeFields.style.display = this.checked ? "block" : "none";
        });
    }, 10);

    overlay.appendChild(modal);
    document.body.appendChild(overlay);
};

const submitVendorStatus = (reqId, poId, userToken) => {
    $.ajax({
        url: "./ajax/json_for_track_po_v1_0.php",
        type: "POST",
        data: {req_id: reqId, po_id: poId},
        dataType: "json",
        contentType: "application/x-www-form-urlencoded",
        headers: {
            "token_id": userToken,
            "mode": "3"
        },
        success: function (response) {
            if (response.error_code === 200) {
                alert("delivered");
                document.getElementById('deliveryPopup').remove()
            } else {
                alert('Error: ' + response.message);
            }
        },
        error: function (xhr) {
            console.log("AJAX Error:", xhr.responseText);
            alert("Server error. Please try again.");
        }
    });
}
const poItemList = (reqId, poId, userToken) => {

    // work on progress 


    $.ajax({
        url: "./ajax/json_for_track_po_v1_0.php",
        type: "POST",
        data: {req_id: reqId, po_id: poId},
        dataType: "json",
        contentType: "application/x-www-form-urlencoded",
        headers: {
            "token_id":userToken,
            "mode": "4"
        },
        success: function (response) {
            console.log(response);
            if (response.error_code === 200) {
                const data = response.data;

                console.log(data);
                document.getElementById('vendorName').textContent = response.ven_name;
                document.getElementById('poNumber').textContent = response.po_no;
              
                const tbody = document.getElementById('poItemsBody');
                tbody.innerHTML = "";
              
                data.forEach((item, index) => {
                  const row = document.createElement("tr");
                  row.innerHTML = `
                    <td>${index + 1}</td>
                    <td>${item.item_name}</td>
                    <td>${item.item_drawing_no}</td>
                    <td>${item.item_part_no}</td>
                    <td>${item.allocated_qty}</td>
                  `;
                  tbody.appendChild(row);
                });
                document.getElementById('poModal').style.display = 'block';

            } else {
                alert('Error: ' + response.message);
            }
        },
        error: function (xhr) {
            console.log("AJAX Error:", xhr.responseText);
            alert("Server error. Please try again.");
        }
    });

}
function closeModal() {
    document.getElementById('poModal').style.display = 'none';
  }
